//STOOL information
TOOL.Category		= "Constraints"
TOOL.Name			= "Player Weld"
TOOL.Command		= nil
TOOL.ConfigName		= nil

//Language strings
if CLIENT then
	language.Add( "Tool_playerweld_name", "Player Weld" )
	language.Add( "Tool_playerweld_desc", "Weld yourself to props or weld props to yourself!" )
	language.Add( "Tool_playerweld_0", "Primary: Weld yourself to a prop      Secondary: Weld the prop to yourself      Reload: Unweld everything" )
end

//Weld the player to a prop
function TOOL:LeftClick( Trace )
	if CLIENT then
		if Trace.HitNonWorld then
			return true
		else
			return false
		end
	end
	
	if Trace.HitNonWorld then
		local Prop = Trace.Entity
		local Ply = self:GetOwner()
		local Offset = Prop:GetPos() - Ply:GetPos()
		
		//Here we set the prop for the player to 'weld' to and the offset
		Ply:SetNWInt( "Parent", Prop:EntIndex() )
		Ply:SetNetworkedVector( "Offset", Offset )

		//Ply:SetNotSolid(true)
		
		//Inform the player
		Ply:SendLua("GAMEMODE:AddNotify(\"You are now weld to this prop!\", NOTIFY_GENERIC, 8); surface.PlaySound( \"".. "ambient/water/drip" .. math.random(1, 4) .. ".wav" .."\" )")
		
		return true
	end
end

//Weld the player to a prop
function TOOL:RightClick( Trace )
	if CLIENT then
		if Trace.HitNonWorld then
			return true
		else
			return false
		end
	end
	
	if Trace.HitNonWorld then
		local Prop = Trace.Entity
		local Ply = self:GetOwner()
		local Offset = Prop:GetPos() - Ply:GetPos()
		
		//Here we set the player for the prop to 'weld' to and the offset
		Prop:SetNWInt( "Parent", Ply:EntIndex() )
		Prop:SetNetworkedVector( "Offset", Offset )
		Prop:SetNetworkedVector( "Rotation", Prop:GetAngles() )
		
		//Inform the player
		Ply:SendLua("GAMEMODE:AddNotify(\"This prop is now weld to you!\", NOTIFY_GENERIC, 8); surface.PlaySound( \"".. "ambient/water/drip" .. math.random(1, 4) .. ".wav" .."\" )")
		
		return true
	end
end

//Unweld everything
function TOOL:Reload()
	if CLIENT then return end
	
	local Ply = self:GetOwner()
	Ply:SetNWInt( "Parent", 0 )
	Ply:SetMoveType( MOVETYPE_WALK )
	
	for _, ent in pairs(ents.GetAll()) do
		if ent:GetNWInt("Parent") == Ply:EntIndex() then
			ent:SetNWInt( "Parent", 0 )
			ent:SetParent( nil )
		end
	end
	
	Ply:SendLua("GAMEMODE:AddNotify(\"Cleaned up all constraints!\", NOTIFY_CLEANUP, 8); surface.PlaySound( \"".. "ambient/water/drip" .. math.random(1, 4) .. ".wav" .."\" )")
end